#ifdef __ADFS__

#include "Carbon68kGlue.h"
#include "A2Pix_AE.h"
#include <string.h>

typedef unsigned long ulong;

static	PicHandle	PixRecToNewPicHandle(ProcessSerialNumber *psnP, A2Pix_AE_RecH a2p_aeRecH)
{
	AppleEvent	aeEvent, replyEvent;
	AEDesc		aeDesc;
	ulong		sizeL;
	PicHandle	a2PictH	= NULL;
	OSErr		err		= noErr, err2 = noErr;
	
	err = AECreateDesc(
		typeProcessSerialNumber, 
		(Ptr)psnP, 
		sizeof(ProcessSerialNumber), 
		&aeDesc);
	
	if (!err) {
		// Create an empty ae
		err = AECreateAppleEvent(
			kA2Pix_EventClass, 
			kA2Pix_ConvertEventID, 
			&aeDesc, 
			kAutoGenerateReturnID, 
			kA2Pix_TransactionID, 
			&aeEvent);
		
		err2 = AEDisposeDesc(&aeDesc);
	}

	if (!err) {
		err = err2;
		
		if (!err) {
			HLock((Handle)a2p_aeRecH);
			err = AECreateDesc(
			    kA2Pix_AEType_AERec, 
				(Ptr)*a2p_aeRecH,
				GetHandleSize((Handle)a2p_aeRecH),
				&aeDesc);
			HUnlock((Handle)a2p_aeRecH);
			
			if (!err) {
				err = AEPutParamDesc(&aeEvent, keyDirectObject, &aeDesc);

				err2 = AEDisposeDesc(&aeDesc);
				if (!err) err = err2;
			}
		}
		
		if (!err) err = AESend(
			&aeEvent, &replyEvent,
			kAEWaitReply + kAECanInteract + kAEProcessNonReplyEvents,
			kAEHighPriority, 60 * 2, NULL, NULL);
		
		err2 = AEDisposeDesc(&aeEvent);
		if (!err) err = err2;
	}

	if (!err) {
		err = AEGetParamDesc(
			&replyEvent, 
			keyDirectObject, 
			kA2Pix_AEType_BitMap, 
			&aeDesc);
		
		/*
			maybe we don't need to dispose this AEDesc since it's 
			part of the reply which gets disposed down below???
		*/
		
		if (!err) {
			sizeL = AEGetDescDataSize(&aeDesc);
			a2PictH = (PicHandle)NewHandle(sizeL);
			if (a2PictH == NULL) { err = memFullErr; }
			
			if (!err) {
				HLock((Handle)a2PictH);
				err = AEGetDescData(
					&aeDesc, *a2PictH, 
					sizeL);
				HUnlock((Handle)a2PictH);
			}
		}

		err2 = AEDisposeDesc(&replyEvent);
		if (!err) err = err2;
	}
	
	return a2PictH;
}

/*
	mainH can be a 16k DazzleDraw file (auxmem followed by main mem)
		if so auxH should be NULL, and it's considered double high res
	
	otherwise mainH contains the main memory file (ie: BSAVE pic,a$2000,l$2000)
	
	if auxH contains info too, then it's considered double high res
*/

//	returns NULL if error
PicHandle	A2PixConvert(ProcessSerialNumber *psnP, Handle mainH, Handle auxH)
{
	PicHandle			a2PictH		= NULL;
	Boolean				goodB		= FALSE;
	ulong				sizeL		= GetHandleSize(mainH);
	A2Pix_AE_RecH		a2p_aeRecH	= (A2Pix_AE_RecH)NewHandle(sizeof(A2Pix_AE_Rec));
	
	if (a2p_aeRecH) {
		if (sizeL == 0x4000) {
			goodB = TRUE;
//			ASSERT(auxH == NULL);
			
			(**a2p_aeRecH).pageRec.double_hi_res = TRUE;
			memcpy(&(**a2p_aeRecH).pageRec.pages, *mainH, sizeL);
		} else if (sizeL > 0x1FF8 && sizeL <= 0x2004) {
			goodB = TRUE;
			
			if (sizeL > 0x2000) {
				sizeL = 0x2000;
			}
			
			memcpy(&(**a2p_aeRecH).pageRec.pages.main_page, *mainH, sizeL);
			
			if (auxH) {
				sizeL = GetHandleSize(auxH);
				if (sizeL > 0x1FF8 && sizeL <= 0x2004) {
					(**a2p_aeRecH).pageRec.double_hi_res = TRUE;

					if (sizeL > 0x2000) {
						sizeL = 0x2000;
					}
					
					memcpy(&(**a2p_aeRecH).pageRec.pages.aux_page, *auxH, sizeL);
					goodB = TRUE;
				} else {
					goodB = FALSE;
				}
			} else {
				(**a2p_aeRecH).pageRec.double_hi_res = FALSE;
			}
		} else {
			goodB = FALSE;
		}
		
		if (goodB) {
			//	these options make a 1/2 size double-color image
			//	adjust to suit :)
			
			(**a2p_aeRecH).options.bmFinalDepth		= 8;
			(**a2p_aeRecH).options.paletteType		= A2PX_Palette_LAZ;
			//	no need oneBitPalette
			(**a2p_aeRecH).options.bitShifting		= TRUE;
			(**a2p_aeRecH).options.lazEngine		= TRUE;
			(**a2p_aeRecH).options.schemeType		= A2PX_Scheme_LAZ_DOUBLE;
			(**a2p_aeRecH).options.screenSize		= A2PX_ScreenSize_HALF;
			(**a2p_aeRecH).options.aspectCorrect	= FALSE;
			//	no need useMoreMem
			(**a2p_aeRecH).options.bookMatchesLaz	= TRUE;
			(**a2p_aeRecH).options.startScreen		= FALSE;
			
			#ifndef __68k__
				(**a2p_aeRecH).options.qd_area_sample	= FALSE;
			#else
				(**a2p_aeRecH).options.qd_area_sample	= TRUE;
			#endif

			a2PictH = PixRecToNewPicHandle(psnP, a2p_aeRecH);
		}
		
		DisposeHandle((Handle)a2p_aeRecH);
	}
	
	return a2PictH;
}

#endif