//	A2Pix_AE.h
#ifndef _H_A2Pix_AE
#define _H_A2Pix_AE

typedef unsigned short u_short;

#define		kA2pixWidth		280
#define		kA2pixHeight	192

enum {
	A2PX_Palette_ELLS, 
	A2PX_Palette_DEBAB, 
	A2PX_Palette_LAZ, 
	A2PX_Palette_BERNIE, 
	A2PX_Palette_GUS, 
	A2PX_Palette_CANON, 
	A2PX_Palette_IREZ, 
	A2PX_Palette_IIGS, 
	
	A2PX_Palette_NUMTYPES
};
typedef u_short	A2PX_PaletteType;

enum {
	A2PX_OneBitPalette_BLACK_WHITE, 
	A2PX_OneBitPalette_BLACK_GREEN, 
	A2PX_OneBitPalette_BLACK_AMBER,
	
	A2PX_OneBitPalette_NUMTYPES
};
typedef u_short	A2PX_OneBitPalette;


enum {
	A2PX_Scheme_ELLS, 
	A2PX_Scheme_LAZ_DOUBLE, 
	A2PX_Scheme_LAZ_SHARP, 
	
	A2PX_Scheme_NUMTYPES
};
typedef u_short	A2PX_SchemeType;

enum {
	A2PX_ScreenSize_HALF, 
	A2PX_ScreenSize_NORMAL, 
	A2PX_ScreenSize_DOUBLE, 
	
	A2PX_ScreenSize_NUMTYPES
};
typedef u_short	A2PX_ScreenSize;
enum {
	A2PX_AspectCorrect_NONE, 
	A2PX_AspectCorrect_NORMAL, 
	A2PX_AspectCorrect_DV, 
	
	A2PX_AspectCorrect_NUMTYPS
};
typedef u_short	A2PX_AspectCorrect;

typedef struct {
	u_short				bmFinalDepth;		//	dest. depth
	A2PX_PaletteType	paletteType;		//	color again
	A2PX_OneBitPalette	oneBitPalette;		//	B&W
	Boolean				bitShifting;		//	for HGR only
	Boolean				lazEngine;			//	for color only
	A2PX_SchemeType		schemeType;			//	color and laz only
	A2PX_ScreenSize		screenSize;			//	screen size
	A2PX_AspectCorrect	aspectCorrect;		//	correct for TV pixel aspect ratio
	Boolean				useMoreMem;			//	only when double size + ARC
	Boolean				bookMatchesLaz;		//	use exactly 560 pixels, rather than 562
	Boolean				startScreen;		//	show startup screen (ignore)
	Boolean				qd_area_sample;		//	use QD for area sample (way faster on 68k, less quality)
} A2PX_OptionsInfo, *A2PX_OptionsInfoP, **A2PX_OptionsInfoH;

typedef	struct	{
	Byte	aux_page[0x2000];
	Byte	main_page[0x2000];
} A2_MemPages;

typedef struct {
	Boolean			double_hi_res;
	A2_MemPages		pages;
} A2Pix_PageRec;

typedef struct {
	A2PX_OptionsInfo	options;
	A2Pix_PageRec		pageRec;
} A2Pix_AE_Rec, *A2Pix_AE_RecP, **A2Pix_AE_RecH;

#define		kA2Pix_EventClass		'a2px'
#define		kA2Pix_ConvertEventID	'cvrt'
#define		kA2Pix_TransactionID	'a2xa'
#define		kA2Pix_AEType_AERec		'a2rc'
#define		kA2Pix_AEType_BitMap	'a2bm'

PicHandle	A2PixConvert(ProcessSerialNumber *psnP, Handle mainH, Handle auxH);

#endif