//	Carbon68kGlue.c

#include "FSUtils.h"
#include "Carbon68kGlue.h"

#if 0
	#include "ADFS_LogFile.h"
#else
	#define	ADFS_Log(foo)
#endif

void	ConcatA(unsigned char *srcStr1, unsigned char *srcStr2, unsigned char *dstString)
{
	int		i, offset;
	Str255	final;

	CopyStringA(srcStr1, &final);
	offset = final[0];
	for (i = (*((Str255 *)(srcStr2)))[0]; i > 0; --i)
		if (offset + i < 256)
			final[offset + i] = (*((Str255 *)(srcStr2)))[i];
	final[0] = (unsigned char)((*((Str255 *)(srcStr2)))[0] + offset);
	CopyStringA(&final, dstString);
}

#ifdef __68k__

#define		kEnclosingFolderButton		10
#define		kSelectedFolderButton		11
#define		fFolderFlag		0x10
#define		IsFolderPB(pb)	(Boolean)(((pb)->dirInfo.ioFlAttrib & fFolderFlag) != 0)
#define		IsVisiblePB(pb)	(Boolean)(((pb)->dirInfo.ioDrUsrWds.frFlags & fInvisible) == 0)
#define		EqualString(str1, str2)		(Boolean)(IUEqualString((str1), (str2)) == 0)

PixMapHandle	GetPortPixMap(GWorldPtr gWorldP)
{
	return GetGWorldPixMap(gWorldP);
}

GrafPtr			GetDialogPort(DialogRef theWindowP)
{
	return (GrafPtr)theWindowP;
}

Rect			*GetPortBounds(CGrafPtr grafP, Rect *boundsR)
{
	*boundsR = grafP->portRect;
	return boundsR;
}

Rect			*GetRegionBounds(RgnHandle theRgn, Rect *boundsR)
{
	*boundsR = (**theRgn).rgnBBox;
	return boundsR;
}

Cursor			*GetQDGlobalsArrow(Cursor *arrowP)
{
	*arrowP = qd.arrow;
	return arrowP;
}

BitMap			*GetPortBitMapForCopyBits(GWorldPtr gWorldP)
{
	return &(((GrafPtr)gWorldP)->portBits);
}

Size			AEGetDescDataSize(
	const AEDesc	*theAEDesc)
{
	return GetHandleSize(theAEDesc->dataHandle);
}

OSErr			AEGetDescData(
	const AEDesc	*theAEDesc,
	void			*dataPtr,
	Size			maximumSize)
{
	memcpy(dataPtr, *theAEDesc->dataHandle, (unsigned long)maximumSize);
	
	return noErr;
}

FMFontFamily	FMGetFontFamilyFromName(const unsigned char *string)
{
	short	fNum;
	
	GetFNum(string, &fNum);
	
	return (FMFontFamily)fNum;
}

pascal  OSStatus	GetWindowRegion(
	WindowRef          window,
	WindowRegionCode   inRegionCode,
	RgnHandle          ioWinRgn)
{
	switch (inRegionCode) {
		
		case kWindowStructureRgn: {
			GetWindowStructureRgn(window, ioWinRgn);
			break;
		}
		
		default: {
			DebugStr("\pExiting because of programmer break.");
			break;
		}
	}
	
	return 0;
}  


pascal void			QDFlushPortBuffer(CGrafPtr portP, RgnHandle flushRgn)
{
	#pragma unused (flushRgn)
	#pragma unused (portP)
	//	nothing
}

OSErr	GetThemeTextDimensions(
	CFStringRef	stringRef, short flag, short state, 
	Boolean someB, Point *boundsPt, short *baselineS)
{
	FontInfo		fInfo;
	
	GetFontInfo(&fInfo);
	*baselineS	= fInfo.ascent + fInfo.leading;

	boundsPt->h = TextWidth(stringRef, 0, strlen(stringRef));
	boundsPt->v = *baselineS + fInfo.descent;
	
	return noErr;
}

Boolean	CFStringGetCString(CFStringRef srcZ, char *destZ, long max_bufL, void *goo)
{
	long	sizeL = strlen(srcZ) - 1;

	if (sizeL > max_bufL) {
		sizeL = max_bufL - 1;
	}
	
	memcpy(destZ, srcZ, sizeL);
	
	return TRUE;
}

void		CopyPascalStringToC(const unsigned char *p_str, char *c_str)
{
	unsigned	char	pstr[256];
	register	int		i;
	char		*src;

	CopyStringA((void *)p_str, (void *)pstr);

	src = (char *)pstr;
	
	i = p_str[0];
	
	src++;
	
	for (; i > 0; --i)	{
		*c_str = *src;
		++src;
		++c_str;
	}
	
	*c_str = 0;
}

void		CopyCStringToPascal(const char *c_str, unsigned char *p_str)
{
	unsigned	char	pstr[256];
	register	char	*dst;
	unsigned	long	i;

	dst = (char *)pstr;
	
	i = strlen(c_str);
	
	if (i > 255) {
		i = 255;
	}
	
	dst[0] = (char)i;
	dst++;
	
	for (; i > 0; --i)	{
		*dst = *c_str;
		++c_str;
		++dst;
	}
	
	CopyStringA(pstr, p_str);
}

pascal long		InvalWindowRect(WindowPtr theWindow, const Rect *theRect)
{
	GrafPtr		savePort;
	
	GetPort(&savePort);
	SetPort(theWindow);
	InvalRect(theRect);
	SetPort(savePort);
	
	return 0;
}

pascal long		InvalWindowRgn(WindowPtr theWindow, RgnHandle theRgn)
{
	GrafPtr		savePort;
	
	GetPort(&savePort);
	SetPort(theWindow);
	InvalRgn(theRgn);
	SetPort(savePort);
	
	return 0;
}

pascal	void		EnableMenuItem(MenuRef theMenu, unsigned short menuItem)
{
	EnableItem(theMenu, (short)menuItem);
}

pascal	void		DisableMenuItem(MenuRef theMenu, unsigned short menuItem)
{
	DisableItem(theMenu, (short)menuItem);
}

pascal	WindowRef	GetFrontWindowOfClass(unsigned long what, unsigned char huh)
{
	#pragma unused(huh)
	WindowRef		frontWindow = FrontWindow();
	
	switch (what) {

		case kDocumentWindowClass: {
		
			while (GetWRefCon(frontWindow) == kFloaterWindowRefcon) {
				frontWindow = GetNextWindow(frontWindow);
			}
			break;
		} 
		
		case kFloatingWindowClass: {
			break;
		}
		
		default: {
			//AlertID("Flesh out GetFrontWindowOfClass().", -1);
			break;
		}
	}
	
	return frontWindow;
}

pascal short		NavGetDefaultDialogOptions(NavDialogOptions *optionsP)
{
	#pragma unused(optionsP)
	return 0;
}

static	pascal	Boolean	Nav68FilterProc(
	CInfoPBPtr	pb, 
	void		*yourDataPtr
) {
	Nav_GetFolderRecP	gfRecP			= (Nav_GetFolderRecP)yourDataPtr;
	Boolean				hideThisFile	= FALSE;
	FSSpec				fsSpec;
	AEDesc				theItem;
	NavFileOrFolderInfo	info;
	
	ADFS_Log("Nav68FilterProc start\n");

	if (gfRecP->select == Nav_FileSelect_FOLDER) {
		ADFS_Log("hide this file? ");
		hideThisFile = (Boolean)(!IsFolderPB(pb));
		if (hideThisFile) {
			ADFS_Log("hide\n");
		} else {
			ADFS_Log("show\n");
		}
	}
	
	if (!hideThisFile) {
		FSSpec			*fsSpecP = &fsSpec;
		
		ADFS_Log("copy string\n");
		CopyStringA(pb->hFileInfo.ioNamePtr, fsSpec.name);
		
		theItem.descriptorType							= typeFSS;
		theItem.dataHandle								= (Handle)&fsSpecP;
		
		info.isFolder									= IsFolderPB(pb);
		info.visible									= IsVisiblePB(pb);
		info.fileAndFolder.fileInfo.finderInfo.fdType	= (unsigned long)pb->hFileInfo.ioFlFndrInfo.fdType;
		info.fileAndFolder.fileInfo.dataSize			= (unsigned long)pb->hFileInfo.ioFlLgLen;

		ADFS_Log("filter proc\n");
		hideThisFile = (Boolean)!(gfRecP->filterProc)(&theItem, &info, NULL, kNavFilteringBrowserList);
	}
	
	ADFS_Log("Nav68FilterProc end\n");
			
	return hideThisFile;
}

static	OSErr	GetEnclosingFolderPath(MenuHandle theMenu, FSSpec *fileSpec)
{
	short	levels = CountMItems(theMenu);
	OSErr	err = noErr;
	
	if (levels == 1) {
		err = FSpFindFolder(
			fileSpec->vRefNum, 
			kDesktopFolderType, 
			fileSpec);
	} else {
		short	loop;
		Str255	pathString, tempString;
		
		pathString[0] = 0;

		for (loop = levels - 1; loop >= 1; loop--) {
			GetMenuItemText(theMenu, loop, tempString);
			ConcatA(pathString, tempString, pathString);
			ConcatA(pathString, "\p:", pathString);
		}
		
		err = FSMakeFSSpec(0, 0, pathString, fileSpec);
	}
	
	return err;
}

static	ControlHandle	GetDialogButton(
	DialogPtr	theDialog, 
	short		theItem
) {
	short		iType;
	Handle		iHandle;
	Rect		iRect;
	
	GetDialogItem(theDialog, theItem, &iType, &iHandle, &iRect);
	
	return (ControlHandle)iHandle;
}

static	void	SetDlgButtonText(
	DialogPtr	theDialog, 
	short		theItem, 
	Str255		theString
) {
	Str255	finalString;
	
	ConcatA("\pChoose ", theString, finalString);
	ConcatA(finalString, "\p", finalString);
	
	SetControlTitle(GetDialogButton(theDialog, theItem), finalString);
}

static	void	AbleDlgButton(
	DialogPtr	theDialog, 
	short		theItem, 
	Boolean		enabled
) {
	HiliteControl(GetDialogButton(theDialog, theItem), enabled ? 0 : 255);
}

static		FileFilterYDUPP		FileFilterCB;
static		DlgHookYDUPP		DialogHookCB;
static		ModalFilterYDUPP	EventProcCB;
static		FSSpec				G_fsSpec;

static pascal Boolean		Nav68EventProc(
	DialogRef		theDialog, 
	EventRecord		*theEvent, 
	short 			*itemHit, 
	void			*yourDataPtr)
{
	Boolean				handledB	= FALSE;

	if (theEvent->what == updateEvt) {
		DialogRef		updtDlg = (DialogRef)theEvent->message;		
		
		ADFS_Log("Nav68EventProc start\n");

		if (updtDlg == theDialog) {
			BeginUpdate(theDialog);
			UpdateDialog(theDialog, theDialog->visRgn);
			EndUpdate(theDialog);
		} else {
			Nav_GetFolderRecP	gfRecP		= (Nav_GetFolderRecP)yourDataPtr;
			NavCBRec			cbRec;

			cbRec.window							= theDialog;
			cbRec.eventData.itemHit					= *itemHit;
			cbRec.eventData.eventDataParms.event	= theEvent;

			ADFS_Log("gfRecP->eventProc\n");
			(gfRecP->eventProc)(kNavCBEvent, &cbRec, NULL);
			handledB = TRUE;
		}

		ADFS_Log("Nav68EventProc end\n");
	}
	
	return handledB;
}

static	pascal short	Nav68GetFolderHook(
	short		item, 
	DialogPtr	theDialog, 
	void		*yourDataPtr
) {
	Nav_GetFolderRecP	gfRecP		= (Nav_GetFolderRecP)yourDataPtr;
	MenuHandle			theMenu		= GetMenuHandle(-4000);
	Str255				curFolder;

	ADFS_Log("Nav68GetFolderHook start\n");

	if (theMenu) {
		ADFS_Log("got the menu\n");
	
		GetMenuItemText(theMenu, 1, curFolder);
		
		AbleDlgButton(theDialog, kEnclosingFolderButton, 
			EqualString(curFolder, "\pDesktop"));

		//	first deal with the enclosing folder
		if (!EqualString(curFolder, gfRecP->enclosingFolder)) {
			CopyStringA(curFolder, gfRecP->enclosingFolder);
			ADFS_Log("text kEnclosingFolderButton\n");
			SetDlgButtonText(theDialog, kEnclosingFolderButton, curFolder);
		}
		
		//	then deal with the selected folder
		if (gfRecP->sfReply->sfIsFolder || gfRecP->sfReply->sfIsVolume) {
			if (!gfRecP->selFoldEnabled) {
				gfRecP->selFoldEnabled = TRUE;
				ADFS_Log("able kSelectedFolderButton\n");
				AbleDlgButton(theDialog, kSelectedFolderButton, TRUE);
			}

			if (!EqualString(gfRecP->sfReply->sfFile.name, gfRecP->selectedFolder)) {
				CopyStringA(gfRecP->sfReply->sfFile.name, gfRecP->selectedFolder);
				ADFS_Log("text kSelectedFolderButton\n");
				SetDlgButtonText(theDialog, kSelectedFolderButton, gfRecP->selectedFolder);
			}
		} else if (gfRecP->selFoldEnabled) {
			gfRecP->selFoldEnabled = FALSE;
			ADFS_Log("disable kSelectedFolderButton\n");
			AbleDlgButton(theDialog, kSelectedFolderButton, FALSE);
		}
	}
	
	switch (item) {

		case kEnclosingFolderButton: {
			ADFS_Log("GetEnclosingFolderPath\n");
			GetEnclosingFolderPath(theMenu, &gfRecP->sfReply->sfFile);
			//	***	NO BREAK!
		}

		case kSelectedFolderButton: {
			item = sfItemOpenButton;
			G_fsSpec = gfRecP->sfReply->sfFile;
			break;
		}
	}
	
	ADFS_Log("Nav68GetFolderHook start\n");

	return item;
}

static	OSErr		CreateDescListFromFSSpec(FSSpec *theSpec, AEDescList *theList)
{
	OSErr		err;
	
	err = AECreateList(NULL, 0, FALSE, theList);
	
	if (!err) {
		err = AEPutPtr(theList, 0, typeFSS, theSpec, sizeof(FSSpec));
		
		if (err) {
			(void)AEDisposeDesc(theList);
		}
	}

	return err;
}

static	OSErr				NavChooseFileOrFolder(
	Nav_FileSelectType	fileSelectType, 
    NavReplyRecord		*reply, 
    NavEventUPP			eventProc0, 
    NavObjectFilterUPP	filterProc0)
{
	OSErr				err			= noErr;
	StandardFileReply	sfReply;
	
	if (DialogHookCB == NULL) {
		FileFilterCB	= NewFileFilterYDProc(Nav68FilterProc);
		DialogHookCB	= NewDlgHookYDProc(Nav68GetFolderHook);
		EventProcCB		= NewModalFilterYDUPP(Nav68EventProc);
	}
	
	if (FileFilterCB == NULL || DialogHookCB == NULL || EventProcCB == NULL) {
		err = memFullErr;
	}

	if (!err) {
		Point				thePoint	=	{	-1, -1	};
		SFTypeList			theTypeList	=	{	0, 0, 0, 0	};
		Nav_GetFolderRec	gfRec;

		gfRec.select				= fileSelectType;
		gfRec.sfReply				= &sfReply;
		gfRec.enclosingFolder[0]	= 0;
		gfRec.selFoldEnabled		= (Boolean)(fileSelectType == Nav_FileSelect_FOLDER);
		gfRec.selectedFolder[0]		= 0;
		gfRec.filterProc			= filterProc0;
		gfRec.eventProc				= eventProc0;
		
		CustomGetFile(
			filterProc0 ? FileFilterCB : NULL, 
			0, theTypeList, &sfReply, 
			fileSelectType == Nav_FileSelect_FOLDER ? 130 : sfGetDialogID,
			thePoint, 
			fileSelectType == Nav_FileSelect_FOLDER ? DialogHookCB : NULL, 
			eventProc0 ? EventProcCB : NULL, 
			NULL, NULL, &gfRec);
		
		reply->validRecord = sfReply.sfGood;
	}

	if (!err && reply->validRecord) {
		
		if (fileSelectType == Nav_FileSelect_FOLDER) {
//			unsigned char	dirStr[256];
			
//			ConcatA("\p:", G_fsSpec.name, dirStr);
//			ConcatA(dirStr, "\p:foo", dirStr);
			
//			err = FSMakeFSSpec(
//				G_fsSpec.vRefNum, G_fsSpec.parID, 
//				dirStr, &sfReply.sfFile);
			
//			if (err == fnfErr) {
//				err = noErr;
//			}
			
//			sfReply.sfFile.name[0] = 0;
		}

		if (!err) err =  CreateDescListFromFSSpec(&sfReply.sfFile, &reply->selection);
	}

	return err;
}

pascal OSErr		NavChooseFile(
    AEDesc				*defaultLocation00, 
    NavReplyRecord		*reply, 
    NavDialogOptions	*dialogOptions00, 
    NavEventUPP			eventProc, 
    NavPreviewUPP		previewProc00, 
    NavObjectFilterUPP	filterProc, 
    NavTypeListHandle	typeList00, 
    void				*callBackUD00)
{
	#pragma unused(defaultLocation00)
	#pragma unused(dialogOptions00)
	#pragma unused(previewProc00)
	#pragma unused(typeList00)
	#pragma unused(callBackUD00)

	return NavChooseFileOrFolder(
		filterProc ? Nav_FileSelect_SPECIFIC_FILE : Nav_FileSelect_ANY_FILE, 
		reply, eventProc, filterProc);
}

pascal	OSErr 	NavChooseFolder(
	AEDesc				*defaultLocation00, 
	NavReplyRecord		*reply, 
	NavDialogOptions	*dialogOptions00, 
	NavEventUPP			eventProc, 
	NavObjectFilterUPP	filterProc, 
	void				*callBackUD00)
{
	#pragma unused(defaultLocation00)
	#pragma unused(dialogOptions00)
	#pragma unused(callBackUD00)

	return NavChooseFileOrFolder(
		Nav_FileSelect_FOLDER, reply, eventProc, filterProc);
}

pascal short	NavDisposeReply(struct NavReplyRecord *navRec)
{
	return AEDisposeDesc(&navRec->selection);
}

pascal OSErr NavPutFile(
    AEDesc				*defaultLocation00, 
    NavReplyRecord		*reply, 
    NavDialogOptions	*dialogOptions, 
    NavEventUPP			eventProc00, 
    OSType				fileType00, 
    OSType				fileCreator00, 
    void				*callBackUD00)
{
	#pragma unused(defaultLocation00)
	#pragma unused(eventProc00)
	#pragma unused(fileType00)
	#pragma unused(fileCreator00)
	#pragma unused(callBackUD00)
	OSErr				err = noErr;
	StandardFileReply	sfReply;

	StandardPutFile(
		dialogOptions->message, 
		dialogOptions->savedFileName, 
		&sfReply);

	reply->validRecord = sfReply.sfGood;
	
	if (reply->validRecord) {
		err = CreateDescListFromFSSpec(&sfReply.sfFile, &reply->selection);
	}
	
	return err;
}

pascal short	NavCompleteSave(
	struct NavReplyRecord *, 
	unsigned long)
{
	return 0;
}

OSStatus	FMActivateFonts(
	const FSSpec	*iFontContainer,
	const FMFilter	*iFilter, /* can be NULL */
	void			*iRefCon,
	OptionBits		iOptions)
{
	#pragma unused(iFontContainer)
	#pragma unused(iFilter)
	#pragma unused(iRefCon)
	#pragma unused(iOptions)

	return noErr;
}

void		GetControlBounds(ControlRef theControl, Rect *theRect)
{
	ControlRecord	**controlH = (ControlRecord **)theControl;
	
	*theRect = (**controlH).contrlRect;
}

GrafPtr		GetControlOwner(ControlRef theControl)
{
	ControlRecord	**controlH = (ControlRecord **)theControl;
	
	return (GrafPtr)(**controlH).contrlOwner;
}

short		GetControlPopupMenuID(ControlRef theControl)
{
	PopupControlPrivateDataH	dataH = (PopupControlPrivateDataH)(**theControl).contrlData;
	
	return (**dataH).menuID;
}

MenuRef		GetControlPopupMenuHandle(ControlRef theControl)
{
	MenuRef						theMenu;
	PopupControlPrivateDataP	*dataH;
	
	dataH = (PopupControlPrivateDataH)(**theControl).contrlData;
	theMenu = (**dataH).theMenu;
	
	return theMenu;
}

void		SetControlPopupMenuHandle(ControlRef theControl, MenuRef theMenu)
{
	PopupControlPrivateDataP	*dataH;
	
	dataH = (PopupControlPrivateDataH)(**theControl).contrlData;
	
	CalcMenuSize(theMenu);
	SetControlMinimum(theControl, 1);
	SetControlMaximum(theControl, CountMItems(theMenu));

	(**dataH).theMenu	= theMenu;
	(**dataH).menuID	= (**theMenu).menuID;
}

void	GetMenuTitle(MenuHandle theMenu, Str255 title)
{
	CopyStringA((**theMenu).menuData, title);
}

OSErr	SetMenuTitle(MenuHandle *theMenu, Str255 newTitle)
{
//	ReportErrorStr(0, "Do not call SetMenuTitle.");
//	ReportError(IC_Err_YOU_WILL_CRASH);
	
	return -1;
}

/*
#define		MOVE_DATA()												\
	source		= &(menuTitlePtr[menuTitlePtr[0] + 1]);				\
	dest		= source + sizeDelta;								\
	memmove(dest, source, dataSize);

#define		RESIZE_HANDLE()											\
		SetHandleSize((Handle)*theMenu, oldHandleSize + sizeDelta);	\
		err = MemError();	if (err) goto done;

#define		GET_TITLE_ADDRESS()										\
	menuTitlePtr = (char *)&((***theMenu).menuData)

#define		SET_TITLE_STRING()										\
	CopyString(newTitle, menuTitlePtr);

OSErr	SetMenuTitle(MenuHandle *theMenu, Str255 newTitle)
{
	OSErr	err = noErr;
	Size	sizeDelta, oldHandleSize, dataSize;
	char	*source = NULL, *dest = NULL, *menuTitlePtr;
	SInt8	state	= HGetState((Handle)*theMenu);
	Boolean	locked	= (state & 0x80) != 0;
	
	if (locked) {
		ReportErrorStr(0, "The menu was locked!");
		HUnlock((Handle)*theMenu);
	}
	
	GET_TITLE_ADDRESS();

	sizeDelta = newTitle[0] - menuTitlePtr[0];

	if (sizeDelta) {
		oldHandleSize	= GetHandleSize((Handle)(*theMenu));
		err				= MemError();	if (err) goto done;
		dataSize		= oldHandleSize - (menuTitlePtr[0] + 1);
	}
	
	if (sizeDelta > 0) {
		//	first make handle bigger
		RESIZE_HANDLE();

		//	(since memory has moved, we must re-establish
		//	the items dereferenced thru the handle)
		GET_TITLE_ADDRESS();

		//	then move the data.
		//MOVE_DATA();
	source		= &(menuTitlePtr[menuTitlePtr[0] + 1]);				
	dest		= source + sizeDelta;								
	memmove(dest, source, dataSize);
		
		//	then set the title. 
		SET_TITLE_STRING();
	} else if (sizeDelta < 0) {
		//	move the data
		//MOVE_DATA();
	source		= &(menuTitlePtr[menuTitlePtr[0] + 1]);				
	dest		= source + sizeDelta;								
	memmove(dest, source, dataSize);
		
		//	then set the title
		SET_TITLE_STRING();
		
		//	then make handle smaller
		RESIZE_HANDLE();
	} else {
		SET_TITLE_STRING();
	}
	
	if (locked) {
		HLock((Handle)*theMenu);
	}

	done:
	return err;
}
*/

OSStatus	DrawThemeTextBox(
  CFStringRef      inString,
  ThemeFontID      inFontID,
  ThemeDrawState   inState,
  Boolean          inWrapToWidth,
  const Rect *     inBoundingBox,
  SInt16           inJust,
  void *           inContext)
{
	TETextBox(inString, (long)strlen(inString), inBoundingBox, inJust);
	return noErr;
}

CFStringRef		CFStringCreateWithCString(
	void	*allocator, 
	char	*buf, 
	short	textEncoding)
{
	return buf;
}

void			CFRelease(CFStringRef stringRef)
{
	//	hah!
}

EXTERN_API( OSStatus )		GetCurrentScrap(ScrapRef *scrap)
{
	return 0;
}

EXTERN_API( OSStatus )		ClearCurrentScrap(void)
{
	return ZeroScrap();
}

EXTERN_API( OSStatus ) 		PutScrapFlavor (
    ScrapRef			scrap, 
    ScrapFlavorType		flavorType, 
    ScrapFlavorFlags	flavorFlags, 
    Size				flavorSize, 
    const void			*flavorData)
{
	return PutScrap(flavorSize, flavorType, (void *)flavorData);
}

short			GetMenuID(MenuRef theMenu)
{
	return (**theMenu).menuID;
}

void	GetPortVisibleRegion(GrafPtr portP, RgnHandle visRgn)
{
	CopyRgn(portP->visRgn, visRgn);
}

Pattern			*GetQDGlobalsGray(Pattern *pat)
{
	*pat = qd.gray;
	return pat;
}

Pattern			*GetQDGlobalsBlack(Pattern *pat)
{
	*pat = qd.black;
	return pat;
}

BitMap			*GetQDGlobalsScreenBits(BitMap *screenBits)
{
	*screenBits = qd.screenBits;
	return screenBits;
}

Style			GetPortTextFace(CGrafPtr portP)
{
	return portP->txFace;
}

short			GetPortTextFont(CGrafPtr portP)
{
	return portP->txFont;
}

short			GetPortTextSize(CGrafPtr portP)
{
	return portP->txSize;
}

short			GetPortTextMode(CGrafPtr portP)
{
	return portP->txMode;
}

OSErr		TrackMouseLocationWithOptions(
	GrafPtr					*port0, 
	short					flagsS, 
	short					durationS, 
	Point					*mousePt, 
	unsigned long			*mods, 
	MouseTrackingResult		*result)
{
	*result = kMouseTrackingMousePressed;

	return noErr;
}

OSStatus	SetWindowModality(
	WindowRef		inWindow,
	WindowModality	inModalKind,
	WindowRef		inUnavailableWindow)
{
	return noErr;
}

SInt16		GetPixDepth(PixMapHandle pixMap)
{
	return (**pixMap).pixelSize;
}

#ifdef OLD68K
OSErr		GetWindowFeatures(WindowPtr theWindow, ulong *featuresL)
{
	short		windowVariantS = GetWVariant(theWindow);
	Boolean		hasGrowIconB;
	
	hasGrowIconB = 
		windowVariantS == zoomDocProc 
		|| windowVariantS == documentProc;
	
	if (hasGrowIconB) {
		*featuresL = kWindowCanGrow;
	}
	
	return noErr;
}
#endif

/*
OSErr	DMSetDisplayMode (
	GDHandle	theDevice, 
	UInt32		mode, 
	UInt32		*depthMode, 
	UInt32		reserved, 
	Handle		displayState)
{
	return SetDepth(theDevice, *depthMode, 1, *depthMode == 1 ? 1 : 0);
}
*/
#endif


extern pascal void MoveControl(ControlRef theControl, SInt16 h, SInt16 v)
 ONEWORDINLINE(0xA959);
extern pascal void SizeControl(ControlRef theControl, SInt16 w, SInt16 h)
 ONEWORDINLINE(0xA95C);
