//	Carbon68kGlue.h
#ifndef _H_Carbon68kGlue
#define	_H_Carbon68kGlue

#include <string.h>

#define		CopyStringA(_srcStr, _dstStr)	memcpy((_dstStr), (_srcStr), (unsigned long)(((char *)(_srcStr))[0] + 1))
void		ConcatA(unsigned char *srcStr1, unsigned char *srcStr2, unsigned char *dstString);

enum {
	Nav_FileSelect_FOLDER, 
	Nav_FileSelect_SPECIFIC_FILE, 
	Nav_FileSelect_TEXT_FILE, 
	Nav_FileSelect_ANY_FILE
};
typedef short Nav_FileSelectType;

#ifdef __68k__

#define		kFloaterWindowRefcon	0x1234

//typedef		UInt32	OptionBits;


//#define __ADFS__
#if 0
//ndef __ADFS__
typedef		OptionBits	FSIteratorFlags;

	typedef	FSSpec		FSRef;
	typedef	FSSpec		*FSIterator;

	OSErr	FSpMakeFSRef(
	  const FSSpec *  source,
	  FSRef *         newRef);

	/* Immediate children of container only */
	#define	  kFSIterateFlat	0

	OSErr	FSOpenIterator(
	  const FSRef *     container,
	  FSIteratorFlags   iteratorFlags,
	  FSIterator *      iterator);

	typedef UInt32                          FSCatalogInfoBitmap;
	#define	kFSCatInfoNone	0x00000000

	/* Iteration ran out of items to return */
	#define	errFSNoMoreItems	-1417

	OSErr	FSGetCatalogInfoBulk(
	  FSIterator            iterator,
	  ItemCount             maximumObjects,
	  ItemCount *           actualObjects,
	  Boolean *             containerChanged,       /* can be NULL */
	  FSCatalogInfoBitmap   whichInfo,
	  void *                catalogInfos,           /* can be NULL */
	  FSRef *               refs,                   /* can be NULL */
	  FSSpec *              specs,                  /* can be NULL */
	  void *                names);                 /* can be NULL */

	OSErr	FSCloseIterator(FSIterator iterator);
#endif

#define GetDialogTextEditHandle(dialog) (((DialogPeek)dialog)->textH)

typedef struct {
	MenuRef		theMenu;
	short		menuID;
	char		reserved;
} PopupControlPrivateData, *PopupControlPrivateDataP, **PopupControlPrivateDataH;

typedef char	*CFStringRef;


//#define __NEW_68k__
#ifdef OLD68K
typedef UInt16                          WindowRegionCode;
enum {
                                        /* Region values to pass into GetWindowRegion & GetWindowBounds */
  kWindowTitleBarRgn            = 0,
  kWindowTitleTextRgn           = 1,
  kWindowCloseBoxRgn            = 2,
  kWindowZoomBoxRgn             = 3,
  kWindowDragRgn                = 5,
  kWindowGrowRgn                = 6,
  kWindowCollapseBoxRgn         = 7,
  kWindowTitleProxyIconRgn      = 8,    /* Mac OS 8.5 forward*/
  kWindowStructureRgn           = 32,
  kWindowContentRgn             = 33,   /* Content area of the window; empty when the window is collapsed*/
  kWindowUpdateRgn              = 34,   /* Carbon forward*/
  kWindowOpaqueRgn              = 35,   /* Mac OS X: Area of window considered to be opaque. Only valid for windows with alpha channels.*/
  kWindowGlobalPortRgn          = 40    /* Carbon forward - bounds of the windows port in global coordinates; not affected by CollapseWindow*/
};

pascal	OSStatus	GetWindowRegion(
	WindowRef          window,
	WindowRegionCode   inRegionCode,
	RgnHandle          ioWinRgn);

#endif

#ifdef OLD68K

	Boolean		CFStringGetCString(CFStringRef srcZ, char *destZ, long max_bufL, void *goo);
	#define		CFStringGetSystemEncoding()	NULL

	#define		MacCompareString		IUCompPString
	#define		MacInsetRect			InsetRect
	
	#define		MacSetCursor(_foo)	SetCursor(_foo)

	#define		FOUR_CHAR_CODE(_foo)				_foo
	
	#define		NewDragSendDataUPP(_foo)			_foo
	#define		DisposeDragSendDataUPP(_foo)		_foo
	
	#define		NewDragTrackingHandlerUPP(_foo)		_foo
	
	#define		NewDragReceiveHandlerUPP(_foo)		_foo
	
	#define		NewControlActionUPP(_foo)			_foo
	#define		DisposeControlActionUPP(_foo)		_foo

	#define		NewUserItemUPP(_foo)				_foo
	#define		DisposeUserItemUPP(_foo)			_foo

	#define		NewAEEventHandlerUPP(_foo)			_foo
	
	/* allow processing of non-reply events while awaiting synchronous AppleEvent reply */
	#define		kAEProcessNonReplyEvents    0x00008000

	typedef	SInt16	DialogItemType;
	
	enum {
		oneBitMode                    = 128,  /*Id of OneBitMode Parameter list.*/
 		kScrapFlavorMaskNone          = 0x00000000,
		kHasNoINITs                   = 0x0080, /* Files only (Extensions/Control Panels only) */
		kFinderIcon                   = 'FNDR',
		kGenericApplicationIcon       = 'APPL',
		kGenericDocumentIcon          = 'docu',
		kGenericFolderIcon            = 'fldr',
		kMountedFolderIcon				= 'mtfl',
		kSharedFolderIcon				= 'shfl'
	};

	OSErr	GetThemeTextDimensions(
		CFStringRef	stringRef, short flag, short state, 
		Boolean someB, Point *boundsPt, short *baselineS);

	void		CopyCStringToPascal(const char *c_str, unsigned char *p_str);
	void		CopyPascalStringToC(const unsigned char *p_str, char *c_str);

	typedef DragReference	DragRef;
	typedef ItemReference	DragItemRef;
	
	typedef void *                          NavCallBackUserData;
	
	

enum {
  kDragFlavorTypeHFS            = FOUR_CHAR_CODE('hfs '), /* flavor type for HFS data*/
  kDragFlavorTypePromiseHFS     = FOUR_CHAR_CODE('phfs'), /* flavor type for promised HFS data*/
  kDragPromisedFlavorFindFile   = FOUR_CHAR_CODE('rWm1'), /* promisedFlavor value for Find File*/
  kDragPromisedFlavor           = FOUR_CHAR_CODE('fssP') /* promisedFlavor value for everything else*/
};

typedef UInt32 NavUserAction;

union NavEventDataInfo {
  EventRecord *       event;                  /* for event processing */
  void *              param;                  /* points to event specific data */
};
typedef union NavEventDataInfo          NavEventDataInfo;
struct NavEventData {
  NavEventDataInfo    eventDataParms;         /* the event data */
  SInt16              itemHit;                /* the dialog item number, for v1.1 or greater */
};
typedef struct NavEventData             NavEventData;

typedef void                    *NavDialogRef;

struct NavCBRec {

  /*
   * The version of the struct (currently 1)
   */
  UInt16              version;

  /*
   * The NavDialogRef this callback with which this call is associated
   */
  NavDialogRef        context;

  /*
   * The dialog's window
   */
  WindowRef           window;

  /*
   * The custom control area rectangle (window coordinates)
   */
  Rect                customRect;

  /*
   * The custom preview area rectangle (window coordinates)
   */
  Rect                previewRect;

  /*
   * The event-specific data, including the EventRecord, if any
   */
  NavEventData        eventData;

  /*
   * The action taken by the user that generated a kNavCBUserAction
   * event (Carbon dialogs only)
   */
  NavUserAction       userAction;

  /*
   * Reserved for future use
   */
  char                reserved[218];
};
typedef struct NavCBRec                 NavCBRec;
typedef NavCBRec *                      NavCBRecPtr;

typedef SInt32 NavEventCallbackMessage;

typedef		void	*FileTranslationSpecArrayHandle;

struct NavReplyRecord {

  /*
   * The version of the structure. The first public version of the
   * structure was version 0. Fields added after version 0, starting
   * with the saveFileName field, are noted below.
   */
  UInt16              version;

  /*
   * True if the reply contains a non-null selection
   */
  Boolean             validRecord;

  /*
   * True if this reply is from a PutFile dialog and the file to be
   * saved already exists and needs to be replaced. The user has
   * already been warned unless the kNavDontConfirmReplacement option
   * flag is used.
   */
  Boolean             replacing;

  /*
   * True if this reply is from a PutFile dialog and the user wants to
   * save the file as stationery.
   */
  Boolean             isStationery;

  /*
   * True if translation was performed on the file(s) to be opened or
   * if transtlation will be needed on the file to be saved.
   */
  Boolean             translationNeeded;

  /*
   * For GetFile or Choose dialogs, a list of items chosen by the user.
   * For the older NavPutFile dialog, a list containing one item: an
   * FSSpec of the file to be saved. ** IMPORTANT NOTE *** For the new
   * Carbon-only PutFile dialog created with NavCreatePutFileDialog,
   * the selection is a list containing one item: the DIRECTORY where
   * the file is to be saved. The file name is obtained from the
   * saveFileName field. When using the original modal API, each
   * descriptor will contain an FSSpec (typeFSS). When using the new
   * Carbon-only dialogs created via the NavCreate*Dialog functions,
   * each descriptor could contain either an FSSpec (typeFSS, used on
   * Mac OS 8 or 9) or an FSRef (typeFSRef, used on Mac OS X). This
   * divergence is caused by the need to use FSRef (for Unicode/HFS+
   * support) on Mac OS X, while being unable to provide FSRefs on Mac
   * OS 8.6.
   */
  AEDescList          selection;

  /*
   * For NavPutFile: the script system associated with the name of the
   * file to be saved.
   */
  ScriptCode          keyScript;

  /*
   * A handle to an array of type FileTranslationSpec. Each array entry
   * corresponds to an item in the selection and describes the
   * translation that was performed (GetFile) or needs to be performed
   * (PutFile) on that item.
   */
  FileTranslationSpecArrayHandle  fileTranslation;

  /*
   * Reserved for private use.
   */
  UInt32              reserved1;

  /*
   * Carbon PutFile dialog only: the name of the file to be saved. This
   * field contains the true file name to saved, even if the extension
   * will be hidden from the user. This field was added in structure
   * version 1.
   */
  CFStringRef         saveFileName;

  /*
   * The extension on the name of the saved file should be hidden. Once
   * the file has been saved, the client should call NavCompleteSave.
   * NavCompleteSave will take care of hiding the extension on the
   * file. However, the client needs to know that the extension is
   * hidden so that it can display the document name correctly in the
   * UI, such as in window titles and menus. This field is only used if
   * the client has r equested extension preservation using the
   * kNavPreserveSaveFileExtension dialog option flag. This field was
   * added in structure version 2.
   */
  Boolean             saveFileExtensionHidden;

  /*
   * Reserved for future use.
   */
  UInt8               reserved2;

  /*
   * Reserved for future use.
   */
  char                reserved[225];
};
typedef struct NavReplyRecord           NavReplyRecord;

	#define		kNavCBEvent	0

	typedef pascal void (*NavEventUPP)(
		NavEventCallbackMessage		callBackSelector, 
		NavCBRecPtr					callBackParms, 
		NavCallBackUserData			callBackUD);

	typedef SInt16 NavFilterModes;
	enum {
	                                        /* which elements are being filtered for objects: */
	  kNavFilteringBrowserList      = 0,
	  kNavFilteringFavorites        = 1,
	  kNavFilteringRecents          = 2,
	  kNavFilteringShortCutVolumes  = 3,
	  kNavFilteringLocationPopup    = 4     /* for v1.1 or greater */
	};

	typedef	pascal Boolean (*NavObjectFilterUPP)(
	    AEDesc			*theItem, 
	    void			*info, 
	    void			*callBackUD, 
	    NavFilterModes	filterMode);
	
	typedef void *NavMenuItemSpecArrayHandle;
	typedef UInt32 NavDialogOptionFlags;
enum {
  kNavDefaultNavDlogOptions     = 0x000000E4, /* use defaults for all the options */
  kNavNoTypePopup               = 0x00000001, /* don't show file type/extension popup on Open/Save */
  kNavDontAutoTranslate         = 0x00000002, /* don't automatically translate on Open */
  kNavDontAddTranslateItems     = 0x00000004, /* don't add translation choices on Open/Save */
  kNavAllFilesInPopup           = 0x00000010, /* "All Files" menu item in the type popup on Open */
  kNavAllowStationery           = 0x00000020, /* allow saving of stationery files */
  kNavAllowPreviews             = 0x00000040, /* allow preview to show */
  kNavAllowMultipleFiles        = 0x00000080, /* allow multiple items to be selected */
  kNavAllowInvisibleFiles       = 0x00000100, /* allow invisible items to be shown */
  kNavDontResolveAliases        = 0x00000200, /* don't resolve aliases */
  kNavSelectDefaultLocation     = 0x00000400, /* make the default location the browser selection */
  kNavSelectAllReadableItem     = 0x00000800, /* make the dialog select "All Readable Documents" on open */
  kNavSupportPackages           = 0x00001000, /* recognize file system packages, v2.0 or greater */
  kNavAllowOpenPackages         = 0x00002000, /* allow opening of packages, v2.0 or greater */
  kNavDontAddRecents            = 0x00004000, /* don't add chosen objects to the recents list, v2.0 or greater */
  kNavDontUseCustomFrame        = 0x00008000, /* don't draw the custom area bevel frame, v2.0 or greater */
  kNavDontConfirmReplacement    = 0x00010000, /* don't show the "Replace File?" alert on save conflict, v3.0 or greater */
  kNavPreserveSaveFileExtension = 0x00020000 /* extension in default file name is preserved and initially hidden, v3.1 or greater */
};
	
	struct NavDialogOptions {
	  UInt16              version;
	  NavDialogOptionFlags  dialogOptionFlags;    /* option flags for affecting the dialog's behavior */
	  Point               location;               /* top-left location of the dialog, or {-1,-1} for default position */
	  Str255              clientName;
	  Str255              windowTitle;
	  Str255              actionButtonLabel;      /* label of the default button (or null string for default) */
	  Str255              cancelButtonLabel;      /* label of the cancel button (or null string for default) */
	  Str255              savedFileName;          /* default name for text box in NavPutFile (or null string for default) */
	  Str255              message;                /* custom message prompt (or null string for default) */
	  UInt32              preferenceKey;          /* a key for to managing preferences for using multiple utility dialogs */
	  NavMenuItemSpecArrayHandle  popupExtension; /* extended popup menu items, an array of NavMenuItemSpecs */
	  char                reserved[494];
	};
	typedef struct NavDialogOptions         NavDialogOptions;

	typedef SInt16		DialogItemIndex;

	ModalFilterUPP	NewModalFilterUPP(ModalFilterProcPtr userRoutine);
	#if !OPAQUE_UPP_TYPES
	  #ifdef __cplusplus
	    inline ModalFilterUPP NewModalFilterUPP(ModalFilterProcPtr userRoutine) { return (ModalFilterUPP)NewRoutineDescriptor((ProcPtr)(userRoutine), uppModalFilterProcInfo, GetCurrentArchitecture()); }
	  #else
	    #define NewModalFilterUPP(userRoutine) (ModalFilterUPP)NewRoutineDescriptor((ProcPtr)(userRoutine), uppModalFilterProcInfo, GetCurrentArchitecture())
	  #endif
	#endif

	void	DisposeModalFilterUPP(ModalFilterUPP userUPP);
	#if !OPAQUE_UPP_TYPES
	  #ifdef __cplusplus
	    inline void DisposeModalFilterUPP(ModalFilterUPP userUPP) { DisposeRoutineDescriptor((UniversalProcPtr)userUPP); }
	  #else
	    #define DisposeModalFilterUPP(userUPP) DisposeRoutineDescriptor(userUPP)
	  #endif
	#endif

	ModalFilterYDUPP	NewModalFilterYDUPP(ModalFilterYDProcPtr userRoutine);
	#if !OPAQUE_UPP_TYPES
//	  enum { uppModalFilterYDProcInfo = 0x00003FD0 };  /* pascal 1_byte Func(4_bytes, 4_bytes, 4_bytes, 4_bytes) */
	  #ifdef __cplusplus
	    inline ModalFilterYDUPP NewModalFilterYDUPP(ModalFilterYDProcPtr userRoutine) { return (ModalFilterYDUPP)NewRoutineDescriptor((ProcPtr)(userRoutine), uppModalFilterYDProcInfo, GetCurrentArchitecture()); }
	  #else
	    #define NewModalFilterYDUPP(userRoutine) (ModalFilterYDUPP)NewRoutineDescriptor((ProcPtr)(userRoutine), uppModalFilterYDProcInfo, GetCurrentArchitecture())
	  #endif
	#endif

	#define	NewNavEventUPP(_foo)		_foo
	#define	NewNavObjectFilterUPP(_foo)	_foo
	
	#define	DisposeNavEventUPP(_foo)
	#define	DisposeNavObjectFilterUPP(_foo)
	
	#define		cfragNoClientMemErr		12345

	#define	EXTERN_API(_FOO)	_FOO
	
	typedef		void	*ScrapRef;
	typedef		void	*FMFilter;
	typedef		void	*NavTypeListHandle;
	typedef		void	*NavPreviewUPP;

	pascal	void		EnableMenuItem(MenuRef theMenu, unsigned short menuItem);
	pascal	void		DisableMenuItem(MenuRef theMenu, unsigned short menuItem);
	pascal	WindowRef	GetFrontWindowOfClass(unsigned long what, unsigned char huh);
	pascal	short		NavGetDefaultDialogOptions(NavDialogOptions *optionsP);
	
	#define		kioFlAttribDirMask		ioDirMask

	/* Expected a folder, got a file */
	#define		errFSNotAFolder			(OSErr)(-1407)

	/* Use a filetype in this range to indicate that a file is temporarily busy */
	/* (while it is being downloaded or installed, for example).  This prevents */
	/* Finder 8.5 and later from trying to change the item's attributes before it */
	/* is fully created. -- If you provide a series of 'BNDL' icons for your creator */
	/* and some of these filetypes, you can achieve limited icon animation while */
	/* the file creation progresses. */
	enum {
		kFirstMagicBusyFiletype       = 'bzy ',
		kLastMagicBusyFiletype        = 'bzy?'
	};

	/* Use this date as a file's or folder's creation date to indicate that it is */
	/* temporarily busy (while it is being downloaded or installed, for example). */
	/* This prevents Finder from trying to change the item's attributes before it */
	/* is fully created (Finder 8.5 and 8.6 check file creation dates; later Finders */
	/* may check folder creation dates as well). */
	enum {
		kioFlAttribLockedMask         = 0x01,
		kMagicBusyCreationDate        = 0x4F3AFDB0
	};

	enum {
		kDragPseudoCreatorVolumeOrDirectory = 'MACS',	/* "creator code" for volume or directory*/
		kDragPseudoFileTypeVolume     = 'disk',			/* "file type" for volume*/
		kDragPseudoFileTypeDirectory  = 'fold'			/* "file type" for directory*/
	};

	struct NavFileOrFolderInfo {
		UInt16              version;
		Boolean             isFolder;
		Boolean             visible;
		UInt32              creationDate;
		UInt32              modificationDate;

		union {
			struct {
				Boolean             locked;             /* file is locked */
				Boolean             resourceOpen;       /* resource fork is opened */
				Boolean             dataOpen;           /* data fork is opened */
				Boolean             reserved1;
				UInt32              dataSize;           /* size of the data fork */
				UInt32              resourceSize;       /* size of the resource fork */
				FInfo               finderInfo;         /* more file info: */
				FXInfo              finderXInfo;
			} fileInfo;

			struct {
				Boolean             shareable;
				Boolean             sharePoint;
				Boolean             mounted;
				Boolean             readable;
				Boolean             writeable;
				Boolean             reserved2;
				UInt32              numberOfFiles;
				DInfo               finderDInfo;
				DXInfo              finderDXInfo;
				OSType              folderType;         /* package type, For struct version >= 1 */
				OSType              folderCreator;      /* package creator, For struct version >= 1 */
				char                reserved3[206];
			} folderInfo;

		} fileAndFolder;
	};
	
	typedef struct NavFileOrFolderInfo      NavFileOrFolderInfo;

	pascal OSErr		NavChooseFile(
	    AEDesc				*defaultLocation00, 
	    NavReplyRecord		*reply, 
	    NavDialogOptions	*dialogOptions00, 
	    NavEventUPP			eventProc, 
	    NavPreviewUPP		previewProc00, 
	    NavObjectFilterUPP	filterProc, 
	    NavTypeListHandle	typeList00, 
	    void				*callBackUD00);

	pascal	OSErr 	NavChooseFolder(
		AEDesc				*defaultLocation00, 
		NavReplyRecord		*reply, 
		NavDialogOptions	*dialogOptions00, 
		NavEventUPP			eventProc, 
		NavObjectFilterUPP	filterProc, 
		void				*callBackUD00);

	pascal short	NavDisposeReply(struct NavReplyRecord *navRec);
	
	pascal OSErr NavPutFile(
	    AEDesc				*defaultLocation00, 
	    NavReplyRecord		*reply, 
	    NavDialogOptions	*dialogOptions, 
	    NavEventUPP			eventProc00, 
	    OSType				fileType00, 
	    OSType				fileCreator00, 
	    void				*callBackUD00);

	pascal short	NavCompleteSave(
		struct NavReplyRecord *, 
		unsigned long);
		
	OSStatus	FMActivateFonts(
		const FSSpec	*iFontContainer,
		const FMFilter	*iFilter, /* can be NULL */
		void			*iRefCon,
		OptionBits		iOptions);

	typedef OSType			ScrapFlavorType;
	typedef UInt32			ScrapFlavorFlags;

	EXTERN_API( OSStatus )		GetCurrentScrap(ScrapRef *scrap);

	EXTERN_API( OSStatus ) 		PutScrapFlavor (
	    ScrapRef			scrap, 
	    ScrapFlavorType		flavorType, 
	    ScrapFlavorFlags	flavorFlags, 
	    Size				flavorSize, 
	    const void			*flavorData);
	

#endif

typedef struct {
	Nav_FileSelectType	select;
	StandardFileReply	*sfReply;
	Str255				enclosingFolder;
	Boolean				selFoldEnabled;
	Str255				selectedFolder;
	NavEventUPP			eventProc;
    NavObjectFilterUPP	filterProc;
} Nav_GetFolderRec, *Nav_GetFolderRecP;

#define			GetWindowList	LMGetWindowList

PixMapHandle	GetPortPixMap(GWorldPtr gWorldP);
GrafPtr			GetDialogPort(DialogRef theWindowP);
Rect			*GetPortBounds(CGrafPtr grafP, Rect *boundsR);
Rect			*GetRegionBounds(RgnHandle theRgn, Rect *boundsR);
Cursor			*GetQDGlobalsArrow(Cursor *arrowP);
#define			GetQDGlobalsThePort()	qd.thePort
BitMap			*GetPortBitMapForCopyBits(GWorldPtr gWorldP);
void			GetControlBounds(ControlRef theControl, Rect *theRect);
GrafPtr			GetControlOwner(ControlRef theControl);
short			GetControlPopupMenuID(ControlRef theControl);
void			SetControlPopupMenuHandle(ControlRef theControl, MenuRef theMenu);
MenuRef			GetControlPopupMenuHandle(ControlRef theControl);

Pattern			*GetQDGlobalsGray(Pattern *pat);
Pattern			*GetQDGlobalsBlack(Pattern *pat);
BitMap			*GetQDGlobalsScreenBits(BitMap *screenBits);
Style			GetPortTextFace(CGrafPtr portP);
short			GetPortTextFont(CGrafPtr portP);
short			GetPortTextSize(CGrafPtr portP);
short			GetPortTextMode(CGrafPtr portP);
short			GetMenuID(MenuRef theMenu);

void	GetMenuTitle(MenuRef theMenu, Str255 title);
OSErr	SetMenuTitle(MenuRef *theMenu, Str255 newTitle);

Size			AEGetDescDataSize(
	const AEDesc	*theAEDesc);

OSErr			AEGetDescData(
	const AEDesc	*theAEDesc,
	void			*dataPtr,
	Size			maximumSize);

void	GetPortVisibleRegion(GrafPtr portP, RgnHandle visRgn);

typedef UInt32 WindowModality;
enum {
  kWindowModalityNone           = 0,
  kWindowModalitySystemModal    = 1,
  kWindowModalityAppModal       = 2,
  kWindowModalityWindowModal    = 3
};

OSStatus	SetWindowModality(
	WindowRef		inWindow,
	WindowModality	inModalKind,
	WindowRef		inUnavailableWindow);

#define			kThemeCurrentPortFont		200

CFStringRef		CFStringCreateWithCString(
	void *allocator, char *buf, short textEncoding);

void			CFRelease(CFStringRef stringRef);

#ifdef OLD68K
	typedef UInt16                          ThemeFontID;
	typedef UInt32                          ThemeDrawState;

	pascal long		InvalWindowRgn(WindowPtr theWindow, RgnHandle theRgn);
	pascal long		InvalWindowRect(WindowPtr theWindow, const Rect *theRect);

	OSStatus		ClearCurrentScrap(void);
	
	#define	MacPtInRect		PtInRect
	#define	MacFrameRect	FrameRect

	enum {
		kWindowCanGrow                = (1 << 0),
		kWindowCanZoom                = (1 << 1),
		kWindowCanCollapse            = (1 << 2),
		kWindowIsModal                = (1 << 3),
		kWindowCanGetWindowRegion     = (1 << 4),
		kWindowIsAlert                = (1 << 5),
		kWindowHasTitleBar            = (1 << 6)
	};
	
	OSErr		GetWindowFeatures(WindowPtr theWindow, unsigned long *featuresL);
	
	#define		kTextEncodingMacRoman		0
 	#define		kThemeStateActive			1

	#define			kFontIDGeneva		geneva
	#define			kFontIDMonaco		monaco
	
	typedef SInt16	FMFontFamily;

	FMFontFamily	FMGetFontFamilyFromName(const unsigned char *string);
	
	#define		kOnAppropriateDisk		-32767

	pascal void			QDFlushPortBuffer(CGrafPtr portP, RgnHandle flushRgn);

	#define		kNavTranslateInPlace		12345

	enum {
		kFloatingWindowClass          = 5L,   /* floats above all other application windows*/
		kDocumentWindowClass          = 6L,   /* document windows*/

		kfskdjflaskjdfasfd
	};
	
	typedef		UInt16		MenuItemIndex;
	
	#define	CheckMenuItem	CheckItem

	enum {
		kDragTrackingEnterHandler     = 1,    /* drag has entered handler*/
		kDragTrackingEnterWindow      = 2,    /* drag has entered window*/
		kDragTrackingInWindow         = 3,    /* drag is moving within window*/
		kDragTrackingLeaveWindow      = 4,    /* drag has exited window*/
		kDragTrackingLeaveHandler     = 5     /* drag has exited handler*/
	};

#endif

OSStatus	DrawThemeTextBox(
  CFStringRef      inString,
  ThemeFontID      inFontID,
  ThemeDrawState   inState,
  Boolean          inWrapToWidth,
  const Rect *     inBoundingBox,
  SInt16           inJust,
  void *           inContext);

typedef short	MouseTrackingResult;
#define			kMouseTrackingMousePressed					1
#define			kMouseTrackingMouseReleased					0
#define			kMouseTrackingMouseMoved					2
#define			kTrackMouseLocationOptionDontConsumeMouseUp	1
#define			kEventDurationForever						1

#define	GetWindowFromPort(_p)	((WindowRef)(_p))
#define GetWindowPortBounds(window, bounds) (((*(bounds) = (window)->portRect)), (bounds))

OSErr		TrackMouseLocationWithOptions(
	GrafPtr					*port0, 
	short					flagsS, 
	short					durationS, 
	Point					*mousePt, 
	unsigned long			*mods, 
	MouseTrackingResult		*result);

SInt16		GetPixDepth(PixMapHandle pixMap);
/*
OSErr	DMSetDisplayMode(
	GDHandle	theDevice, 
	UInt32		mode, 
	UInt32		*depthMode, 
	UInt32		reserved, 
	Handle		displayState);
*/
#endif
#endif
