#ifndef _H_FSUtils
#define _H_FSUtils

#ifndef __GNUC__
	#include "Drag.h"
	#include "Files.h"
#endif

#include "Carbon68kGlue.h"
#include "ByteMunger.h"

#ifndef __68k__
	#define	kOnUserDisk		kOnAppropriateDisk
#else
	#define	kOnUserDisk		kOnSystemDisk
#endif

#ifndef __ADFS__
	#define	IC_Err_INVISIBLE_FILE			12345
#endif

/*******************************************************
	non FileSpec calls
*/
OSErr		FSGetVolSize(short vRefNum, ulong *freeSpaceL);
OSErr		FSGetVolDriveNum(short vRefNum, short *driveNumS);
OSErr		FSFlushFile(short fileRefNum);

/*
	drag calls
*/
OSErr		FSSpecFromDragRef(DragRef dragRef, Str32 fName, FSSpec *fsSpecP);
OSErr		DragWentToTrash(DragRef theDrag, Boolean *inTrashB);

OSErr		HFSFlavorDataFromDrag(
	DragReference	theDrag, 
	ItemReference	itemRef, 
	HFSFlavor		*hfsFlavor);

/*******************************************************
	folder calls
*/
//	see		FSpCreateFileOrFolder() below
OSErr		FSpIsFolder(FSSpec *fileSpec, Boolean *isFolderB);
OSErr		FSpGetFolderID(FSSpec *folderSpecP, long *dirID);
OSErr		FSpGetParentFolder(FSSpec *fileSpec, FSSpec *parentSpec);
OSErr		FSpGetParentVolume(FSSpec *fileSpec, FSSpec *parentSpec);

OSErr		FSpCountFilesInFolder(FSSpec *folderSpecP, ulong *numFilesL);
OSErr		FSpGetIndFileInFolder(
	FSSpec	*folderSpecP, 
	ulong	fileIndex, 
	FSSpec	*indFileSpecP);

OSErr		FSpFindFolder(
	short		vRefNum, 
	OSType		folderType, 
	FSSpec		*fileSpec);

/*******************************************************
	misc FSp calls
*/
OSErr		FSpThisApp(FSSpec *appFSSpec);

OSErr		FSpResolveAlias(
	FSSpec		*fileSpecP);

Boolean		FSpEqual(
	FSSpec	*spec1, 
	FSSpec	*spec2);

//	typical constant, but you can use whatever you want
#define		kMaxFilePathLen		2048
OSErr		FSpGetFullPath(
	FSSpec	*specP, 
	short	maxPathLen, 
	char	*pathZ);

OSErr		FSpGetCatFInfo(FSSpec *fileSpec, FInfo *fInfoP);
OSErr		FSpSetCatFInfo(FSSpec *fileSpec, FInfo *fInfoP);

OSErr		FSpGetXFInfo(FSSpec *fileSpec, FXInfo *xFInfoP);
OSErr		FSpSetXFInfo(FSSpec *fileSpec, FXInfo *xFInfoP);

OSErr	FSpSetFileTypeAndCreator(
	FSSpec				*fileSpec, 
	OSType				fileCreator, 
	OSType				fileType);

OSErr		FSpCreateFileOrFolder(
	FSSpec		*fileSpecP, 
	OSType		fileType, 
	OSType		fileCreator, 
	Boolean		isFolderB);

OSErr	FSpCreateTempFile(
	short				vRefNum, 
	ConstStr255Param	nameP, 
	OSType				fileCreator, 
	OSType				fileType, 
	FSSpec				*returnSpecP);

OSErr		FSpGetFileDates(
	FSSpec		*fileSpec, 
	DateTimeRec	*creDate, 
	DateTimeRec	*modDate);

OSErr		FSpSetFileDates(
	FSSpec		*fileSpec, 
	DateTimeRec	*creDate, 
	DateTimeRec	*modDate);

OSErr		FSpSetMagicBusyDate(FSSpec *fileSpec);

OSErr		FSpGetFileLock(
	FSSpec	*fileSpec, 
	Boolean	*isLockedB);

OSErr		FSpSetFileLock(
	FSSpec		*fileSpecP, 
	Boolean		lockedB);

OSErr		FSpLaunchInFinder(FSSpec *fileSpecP);

OSErr		FSpGetResEOF(FSSpec *fileSpec, long *resSize);

OSErr		FSpGetEOF(FSSpecPtr fileSpec, long *fileSize);
OSErr		FSpSetEOF(FSSpecPtr fileSpec, long fileSize);

/*
	positive [offset] means delete [offset] bytes from
		beginning of file
	
	negative [offset] means add [offset] bytes to beginning
		of file
*/
OSErr		FSpSetSOF(FSSpecPtr origFileSpecP, long offset);

OSStatus	LaunchURL(char *url_AC);
OSErr		FSpMakeWritable(FSSpec *fileSpecP);
OSErr		FSpResolveFile(FSSpec *fileSpecP, FSSpec *goodSpecP);

OSErr		FSpMakeFSSpecFromFolderAndPName(
	FSSpec				*folderP, 
	ConstStr63Param		nameUZ, 
	FSSpec				*destSpecP);

OSErr		FSpMakeFSSpecFromFolderAndCName(
	FSSpec				*folderP, 
	char				*nameZ, 
	FSSpec				*destSpecP);

OSErr		FSpCreateAliasFile(
	FSSpec	*targetFileP, 
	FSSpec	*destFolderP, 
	FSSpec	*aliasP0);

/*
OSErr	FSRefToFSSpec(
	const FSRef	*fsRef, 
	FSSpec		*fsSpec);
*/	
#endif