//	FixedUtils.h

typedef 	long			M_Fixed;
typedef 	unsigned long	M_UFixed;

#define M_BITSOF(type)		(sizeof(type) << 3)
#define M_FIXED_BITS		M_BITSOF(M_Fixed)

#define M_Fixed_ONE			((M_Fixed)0x00010000L)
#define M_Fixed_HALF		((M_Fixed)0x00008000L)

#define M_HALF_FIX			(short)(M_FIXED_BITS >> 1)

#define	M_FIX2INT(X)		(short)((X) >> M_HALF_FIX)
#define M_INT2FIX(X)		(M_Fixed)((long)(X) << M_HALF_FIX)
#define	M_FIX2INT_ROUND(F)	M_FIX2INT((F) + M_Fixed_HALF)

#define	M_FIX2FLOAT(F)		(((double)(F)) / ((FpLong)M_Fixed_ONE))
#define	M_FLOAT2FIX(F)		((M_Fixed)((F) * M_Fixed_ONE + (((F) < 0) ? -0.5 : 0.5)))
